#include "AudioStack/SMT/clSrcState_Off.h"
#include "AudioStack/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack
{

void clSrcState_Off::vEnter(clAudioSource* pclAudioSource, tU32 , tU8 enEntryCondition)
{
   // no notification events on intial entry
   if (enEntryCondition != ENTRYCONDITION_INITIAL)
   {
      if (NULL != pclAudioSource)
      {
         pclAudioSource->vNotifyOffDone();
      }
   }
}

void clSrcState_Off::vMsg_WaitFor(clAudioSource* pclAudioSource, tU32 u32UserData)
{
  //instead of directly initialize we may need to wait for other Source
  //to be taken off stack
  // 1) Off -> WaitFor(FM)
  // 1.1) FM is removed from Stack -> WaitFor(FM) -> init()
  vSetState(pclAudioSource, clSrcStateFactory::pclCreateWaitFor(), u32UserData);
}

void clSrcState_Off::vMsg_On(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // sequence is:
   // 1) init() -> init_done()
   // 2) on() -> requesConfirmed() -> on_done()
   // as long as request is not confirmed from FC-Audio, an incoming off-request
   // is not delegated to FC-Audio. It has to be confirmed manually.
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_On(), u32UserData);
}

void clSrcState_Off::vMsg_Pause(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // simple transition from off to pause is just used to differentiate background and foreground-states
   // of sources in MW. No intermediate state required.
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_Pause(), u32UserData);
}

}//namespace

